const webcamElement= document.getElementById('webcam');
let net;
let isPredicting = false;
var result_p = document.getElementById('result_p');
 
function startPredicting(){
 isPredicting=true;
 app();
}
function stopPredicting(){
 isPredicting=false;
 app();
}
function startCapture(){
 isPredicting=true;
 app_capture();
}
async function app(){
 console.log('Loading model..');
 net= await tf.automl.loadImageClassification('model.json');
 console.log('Successfully loaded model');
 
 const webcam = await tf.data.webcam(webcamElement);
 while(isPredicting){
 const img = await webcam.capture();
 const result = await net.classify(img);
 
 console.log(result);
 
 document.getElementById("predictions-mask").innerText=result['0']['label']+": "+Math.round(result['0']['prob']*100)+"%";
 document.getElementById("predictions-no-mask").innerText=result['1']['label']+": "+Math.round(result['1']['prob']*100)+"%";
img.dispose();
 
await tf.nextFrame();
 
 }
}
async function app_capture(){
 console.log('Loading model..');
 net= await tf.automl.loadImageClassification('model.json');
 console.log('Successfully loaded model');
 
 const webcam = await tf.data.webcam(webcamElement);
 const img = await webcam.capture();
 const result = await net.classify(img);
 
 console.log(result);
 
 document.getElementById("predictions-mask").innerText=result['0']['label']+": "+Math.round(result['0']['prob']*100)+"%";
 document.getElementById("predictions-no-mask").innerText=result['1']['label']+": "+Math.round(result['1']['prob']*100)+"%";

 
 scale = 1;
 var canvas = document.querySelector('#canvas');
 var photo = document.querySelector('#photo');
 canvas.width = webcamElement.clientWidth * scale;
 canvas.height = webcamElement.clientHeight * scale;
 canvas.getContext('2d').drawImage(webcamElement, 0, 0, canvas.width, canvas.height);
 
 var data = canvas.toDataURL('image/png');

}